/*****************************************************************************
-  \file : iap2_fill_buffer.c
-  \version : $Id: iap2_fill_buffer.c, v Exp $
-  \release : $Name:$
-  Contains the source code implementation for filling/forming the iAP2 Message from the structure provided
-  \component :
-  \author : Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
-  \copyright (c) 2010 - 2016 Advanced Driver Information Technology.
-  This code is developed by Advanced Driver Information Technology.
-  Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
-  All rights reserved.
-  CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
-           DO NOT CHANGE THE CODE MANUALLY
*****************************************************************************/

#include "iap2_fill_buffer.h"
#include "iap2_calculate_parameter_length.h"
#include "iap2_dlt_log.h"
#include "iap2_utility.h"

S32 iAP2FillMsgBufiAP2AccessoryAuthenticationSerialNumberParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2AccessoryAuthenticationSerialNumberParameter* parameterStructure = (iAP2AccessoryAuthenticationSerialNumberParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AuthenticationSerialNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AuthenticationSerialNumber[count]),
                               currentPosition,
                               IAP2_PAR_ID_AUTHENTICATION_SERIAL_NUMBER_0xAA06,
                               iAP2_blob,
                               iAP2_uint8,
                               parameterStructure->iAP2AuthenticationSerialNumber[count].iAP2BlobLength);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2AuthenticationCertificateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2AuthenticationCertificateParameter* parameterStructure = (iAP2AuthenticationCertificateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AuthenticationCertificate_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AuthenticationCertificate[count]),
                               currentPosition,
                               IAP2_PAR_ID_AUTHENTICATION_CERTIFICATE_0xAA01,
                               iAP2_blob,
                               iAP2_uint8,
                               parameterStructure->iAP2AuthenticationCertificate[count].iAP2BlobLength);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2AuthenticationResponseParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2AuthenticationResponseParameter* parameterStructure = (iAP2AuthenticationResponseParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AuthenticationResponse_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AuthenticationResponse[count]),
                               currentPosition,
                               IAP2_PAR_ID_AUTHENTICATION_RESPONSE_0xAA03,
                               iAP2_blob,
                               iAP2_uint8,
                               parameterStructure->iAP2AuthenticationResponse[count].iAP2BlobLength);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2IdentificationInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2IdentificationInformationParameter* parameterStructure = (iAP2IdentificationInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryFirmwareVersion_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryFirmwareVersion[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_FIRMWARE_VERSION_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryHardwareVersion_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryHardwareVersion[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_HARDWARE_VERSION_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryManufacturer_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryManufacturer[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_MANUFACTURER_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryModelIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryModelIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_MODEL_IDENTIFIER_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryName[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_NAME_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessorySerialNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessorySerialNumber[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_SERIAL_NUMBER_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AppMatchTeamID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AppMatchTeamID[count],
                               currentPosition,
                               IAP2_PAR_ID_APP_MATCH_TEAM_ID_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BluetoothHIDComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2BluetoothHIDComponent(&(parameterStructure->iAP2BluetoothHIDComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothHIDComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 29, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_BLUETOOTH_HID_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2BluetoothHIDComponent(TargetBuffer, &(parameterStructure->iAP2BluetoothHIDComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BluetoothTransportComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2BluetoothTransportComponent(&(parameterStructure->iAP2BluetoothTransportComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothTransportComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 17, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2BluetoothTransportComponent(TargetBuffer, &(parameterStructure->iAP2BluetoothTransportComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CurrentLanguage_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2CurrentLanguage[count],
                               currentPosition,
                               IAP2_PAR_ID_CURRENT_LANGUAGE_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ExternalAccessoryProtocol_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2ExternalAccessoryProtocol(&(parameterStructure->iAP2ExternalAccessoryProtocol[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ExternalAccessoryProtocol: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 10, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2ExternalAccessoryProtocol(TargetBuffer, &(parameterStructure->iAP2ExternalAccessoryProtocol[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2iAP2HIDComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2iAP2HIDComponent(&(parameterStructure->iAP2iAP2HIDComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2iAP2HIDComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 18, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_I_AP2HIDCOMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2iAP2HIDComponent(TargetBuffer, &(parameterStructure->iAP2iAP2HIDComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2LocationInformationComponent(&(parameterStructure->iAP2LocationInformationComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2LocationInformationComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 22, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2LocationInformationComponent(TargetBuffer, &(parameterStructure->iAP2LocationInformationComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MaximumCurrentDrawnFromDevice_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MaximumCurrentDrawnFromDevice[count]),
                               currentPosition,
                               IAP2_PAR_ID_MAXIMUM_CURRENT_DRAWN_FROM_DEVICE_0x1D01,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MessagesRecievedfromDevice_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MessagesRecievedfromDevice[count]),
                               currentPosition,
                               IAP2_PAR_ID_MESSAGES_RECIEVEDFROM_DEVICE_0x1D01,
                               iAP2_blob,
                               iAP2_uint16,
                               parameterStructure->iAP2MessagesRecievedfromDevice[count].iAP2BlobLength);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MessagesSentByAccessory_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MessagesSentByAccessory[count]),
                               currentPosition,
                               IAP2_PAR_ID_MESSAGES_SENT_BY_ACCESSORY_0x1D01,
                               iAP2_blob,
                               iAP2_uint16,
                               parameterStructure->iAP2MessagesSentByAccessory[count].iAP2BlobLength);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PowerProvidingCapability_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PowerProvidingCapability[count]),
                               currentPosition,
                               IAP2_PAR_ID_POWER_PROVIDING_CAPABILITY_0x1D01,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2SerialTransportComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2SerialTransportComponent(&(parameterStructure->iAP2SerialTransportComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2SerialTransportComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 14, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_SERIAL_TRANSPORT_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2SerialTransportComponent(TargetBuffer, &(parameterStructure->iAP2SerialTransportComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2SupportedLanguage_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2SupportedLanguage[count],
                               currentPosition,
                               IAP2_PAR_ID_SUPPORTED_LANGUAGE_0x1D01,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2USBDeviceTransportComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2USBDeviceTransportComponent(&(parameterStructure->iAP2USBDeviceTransportComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBDeviceTransportComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 15, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_USB_DEVICE_TRANSPORT_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2USBDeviceTransportComponent(TargetBuffer, &(parameterStructure->iAP2USBDeviceTransportComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2USBHostHIDComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2USBHostHIDComponent(&(parameterStructure->iAP2USBHostHIDComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBHostHIDComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 23, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_USB_HOST_HIDCOMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2USBHostHIDComponent(TargetBuffer, &(parameterStructure->iAP2USBHostHIDComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2USBHostTransportComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2USBHostTransportComponent(&(parameterStructure->iAP2USBHostTransportComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBHostTransportComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 16, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_USB_HOST_TRANSPORT_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2USBHostTransportComponent(TargetBuffer, &(parameterStructure->iAP2USBHostTransportComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VehicleInformationComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2VehicleInformationComponent(&(parameterStructure->iAP2VehicleInformationComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleInformationComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 20, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_VEHICLE_INFORMATION_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2VehicleInformationComponent(TargetBuffer, &(parameterStructure->iAP2VehicleInformationComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RouteGuidanceDisplayComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2RouteGuidanceDisplayComponent(&(parameterStructure->iAP2RouteGuidanceDisplayComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceDisplayComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 30, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2RouteGuidanceDisplayComponent(TargetBuffer, &(parameterStructure->iAP2RouteGuidanceDisplayComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VehicleStatusComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2VehicleStatusComponent(&(parameterStructure->iAP2VehicleStatusComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VehicleStatusComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 21, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_VEHICLE_STATUS_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2VehicleStatusComponent(TargetBuffer, &(parameterStructure->iAP2VehicleStatusComponent[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2WirelessCarPlayTransportComponent_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2WirelessCarPlayTransportComponent(&(parameterStructure->iAP2WirelessCarPlayTransportComponent[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2WirelessCarPlayTransportComponent: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 24, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_WIRELESS_CAR_PLAY_TRANSPORT_COMPONENT_0x1D01, currentPosition);
            rc = iAP2FillMsgBufiAP2WirelessCarPlayTransportComponent(TargetBuffer, &(parameterStructure->iAP2WirelessCarPlayTransportComponent[count]), currentPosition);
        }
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2IdentificationInformationUpdateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2IdentificationInformationUpdateParameter* parameterStructure = (iAP2IdentificationInformationUpdateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryFirmwareVersion_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryFirmwareVersion[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_FIRMWARE_VERSION_0x1D06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryHardwareVersion_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryHardwareVersion[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_HARDWARE_VERSION_0x1D06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryManufacturer_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryManufacturer[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_MANUFACTURER_0x1D06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryModelIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryModelIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_MODEL_IDENTIFIER_0x1D06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessoryName[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_NAME_0x1D06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessorySerialNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AccessorySerialNumber[count],
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_SERIAL_NUMBER_0x1D06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CurrentLanguage_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2CurrentLanguage[count],
                               currentPosition,
                               IAP2_PAR_ID_CURRENT_LANGUAGE_0x1D06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RequestAppLaunchParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RequestAppLaunchParameter* parameterStructure = (iAP2RequestAppLaunchParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AppBundleID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AppBundleID[count],
                               currentPosition,
                               IAP2_PAR_ID_APP_BUNDLE_ID_0xEA02,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LaunchAlert_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LaunchAlert[count]),
                               currentPosition,
                               IAP2_PAR_ID_LAUNCH_ALERT_0xEA02,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2OOBBTPairingAccessoryInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2OOBBTPairingAccessoryInformationParameter* parameterStructure = (iAP2OOBBTPairingAccessoryInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BluetoothTransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BluetoothTransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_0x00B1,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DeviceClass_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DeviceClass[count]),
                               currentPosition,
                               IAP2_PAR_ID_DEVICE_CLASS_0x00B1,
                               iAP2_uint32,
                               iAP2_none,
                               sizeof(U32) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2OOBBTPairingCompletionInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2OOBBTPairingCompletionInformationParameter* parameterStructure = (iAP2OOBBTPairingCompletionInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ResultCode_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ResultCode[count]),
                               currentPosition,
                               IAP2_PAR_ID_RESULT_CODE_0x00B3,
                               iAP2_uint8,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartRouteGuidanceUpdateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartRouteGuidanceUpdateParameter* parameterStructure = (iAP2StartRouteGuidanceUpdateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RouteGuidanceDisplayComponentID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RouteGuidanceDisplayComponentID[count]),
                               currentPosition,
                               IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5200,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StopRouteGuidanceUpdateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StopRouteGuidanceUpdateParameter* parameterStructure = (iAP2StopRouteGuidanceUpdateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RouteGuidanceDisplayComponentID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RouteGuidanceDisplayComponentID[count]),
                               currentPosition,
                               IAP2_PAR_ID_ROUTE_GUIDANCE_DISPLAY_COMPONENT_ID_0x5203,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2BluetoothComponentInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2BluetoothComponentInformationParameter* parameterStructure = (iAP2BluetoothComponentInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BluetoothComponentStatus_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2BluetoothComponentStatus(&(parameterStructure->iAP2BluetoothComponentStatus[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothComponentStatus: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 0, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_BLUETOOTH_COMPONENT_STATUS_0x4E01, currentPosition);
            rc = iAP2FillMsgBufiAP2BluetoothComponentStatus(TargetBuffer, &(parameterStructure->iAP2BluetoothComponentStatus[count]), currentPosition);
        }
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartBluetoothConnectionUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartBluetoothConnectionUpdatesParameter* parameterStructure = (iAP2StartBluetoothConnectionUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BluetoothTransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BluetoothTransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_0x4E03,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2AcceptCallParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2AcceptCallParameter* parameterStructure = (iAP2AcceptCallParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AcceptAction_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AcceptAction[count]),
                               currentPosition,
                               IAP2_PAR_ID_ACCEPT_ACTION_0x415B,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CallUUID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2CallUUID[count],
                               currentPosition,
                               IAP2_PAR_ID_CALL_UUID_0x415B,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2EndCallParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2EndCallParameter* parameterStructure = (iAP2EndCallParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CallUUID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2CallUUID[count],
                               currentPosition,
                               IAP2_PAR_ID_CALL_UUID_0x415C,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2EndAction_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2EndAction[count]),
                               currentPosition,
                               IAP2_PAR_ID_END_ACTION_0x415C,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2HoldStatusUpdateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2HoldStatusUpdateParameter* parameterStructure = (iAP2HoldStatusUpdateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CallUUID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2CallUUID[count],
                               currentPosition,
                               IAP2_PAR_ID_CALL_UUID_0x415F,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HoldStatusUpdate_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HoldStatusUpdate[count]),
                               currentPosition,
                               IAP2_PAR_ID_HOLD_STATUS_UPDATE_0x415F,
                               iAP2_bool,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2InitiateCallParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2InitiateCallParameter* parameterStructure = (iAP2InitiateCallParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AddressBookID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2AddressBookID[count],
                               currentPosition,
                               IAP2_PAR_ID_ADDRESS_BOOK_ID_0x415A,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DestinationID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2DestinationID[count],
                               currentPosition,
                               IAP2_PAR_ID_DESTINATION_ID_0x415A,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Service_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Service[count]),
                               currentPosition,
                               IAP2_PAR_ID_SERVICE_0x415A,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Type_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Type[count]),
                               currentPosition,
                               IAP2_PAR_ID_TYPE_0x415A,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2MuteStatusUpdateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2MuteStatusUpdateParameter* parameterStructure = (iAP2MuteStatusUpdateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MuteStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MuteStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_MUTE_STATUS_0x4160,
                               iAP2_bool,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2SendDTMFParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2SendDTMFParameter* parameterStructure = (iAP2SendDTMFParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CallUUID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2CallUUID[count],
                               currentPosition,
                               IAP2_PAR_ID_CALL_UUID_0x4161,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Tone_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Tone[count]),
                               currentPosition,
                               IAP2_PAR_ID_TONE_0x4161,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartCallStateUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartCallStateUpdatesParameter* parameterStructure = (iAP2StartCallStateUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AddressBookID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AddressBookID[count]),
                               currentPosition,
                               IAP2_PAR_ID_ADDRESS_BOOK_ID_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CallUUID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CallUUID[count]),
                               currentPosition,
                               IAP2_PAR_ID_CALL_UUID_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ConferenceGroup_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ConferenceGroup[count]),
                               currentPosition,
                               IAP2_PAR_ID_CONFERENCE_GROUP_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Direction_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Direction[count]),
                               currentPosition,
                               IAP2_PAR_ID_DIRECTION_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DisconnectReason_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DisconnectReason[count]),
                               currentPosition,
                               IAP2_PAR_ID_DISCONNECT_REASON_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DisplayName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DisplayName[count]),
                               currentPosition,
                               IAP2_PAR_ID_DISPLAY_NAME_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2IsConferenced_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2IsConferenced[count]),
                               currentPosition,
                               IAP2_PAR_ID_IS_CONFERENCED_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Label_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Label[count]),
                               currentPosition,
                               IAP2_PAR_ID_LABEL_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RemoteID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RemoteID[count]),
                               currentPosition,
                               IAP2_PAR_ID_REMOTE_ID_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Service_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Service[count]),
                               currentPosition,
                               IAP2_PAR_ID_SERVICE_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Status_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Status[count]),
                               currentPosition,
                               IAP2_PAR_ID_STATUS_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2StartTimestamp_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2StartTimestamp[count]),
                               currentPosition,
                               IAP2_PAR_ID_START_TIMESTAMP_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartCommunicationsUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartCommunicationsUpdatesParameter* parameterStructure = (iAP2StartCommunicationsUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AirplaneModeStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AirplaneModeStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_AIRPLANE_MODE_STATUS_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CarrierName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CarrierName[count]),
                               currentPosition,
                               IAP2_PAR_ID_CARRIER_NAME_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CellularSupported_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CellularSupported[count]),
                               currentPosition,
                               IAP2_PAR_ID_CELLULAR_SUPPORTED_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CurrentCallCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CurrentCallCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_CURRENT_CALL_COUNT_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2EndAndAcceptAvailable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2EndAndAcceptAvailable[count]),
                               currentPosition,
                               IAP2_PAR_ID_END_AND_ACCEPT_AVAILABLE_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2FaceTimeAudioEnabled_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2FaceTimeAudioEnabled[count]),
                               currentPosition,
                               IAP2_PAR_ID_FACE_TIME_AUDIO_ENABLED_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2FaceTimeVideoEnabled_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2FaceTimeVideoEnabled[count]),
                               currentPosition,
                               IAP2_PAR_ID_FACE_TIME_VIDEO_ENABLED_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HoldAndAcceptAvailable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HoldAndAcceptAvailable[count]),
                               currentPosition,
                               IAP2_PAR_ID_HOLD_AND_ACCEPT_AVAILABLE_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HoldAvailable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HoldAvailable[count]),
                               currentPosition,
                               IAP2_PAR_ID_HOLD_AVAILABLE_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2InitiateCallAvailable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2InitiateCallAvailable[count]),
                               currentPosition,
                               IAP2_PAR_ID_INITIATE_CALL_AVAILABLE_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MergeAvailable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MergeAvailable[count]),
                               currentPosition,
                               IAP2_PAR_ID_MERGE_AVAILABLE_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MuteStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MuteStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_MUTE_STATUS_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2NewVoiceMailCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2NewVoiceMailCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_NEW_VOICE_MAIL_COUNT_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RegistrationStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RegistrationStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_REGISTRATION_STATUS_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2SignalStrength_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2SignalStrength[count]),
                               currentPosition,
                               IAP2_PAR_ID_SIGNAL_STRENGTH_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2SwapAvailable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2SwapAvailable[count]),
                               currentPosition,
                               IAP2_PAR_ID_SWAP_AVAILABLE_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TelephonyEnabled_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TelephonyEnabled[count]),
                               currentPosition,
                               IAP2_PAR_ID_TELEPHONY_ENABLED_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartListUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartListUpdatesParameter* parameterStructure = (iAP2StartListUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2FavoritesListMax_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2FavoritesListMax[count]),
                               currentPosition,
                               IAP2_PAR_ID_FAVORITES_LIST_MAX_0x4170,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2FavoritesListProperties_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2FavoritesListProperties(&(parameterStructure->iAP2FavoritesListProperties[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2FavoritesListProperties: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 6, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_FAVORITES_LIST_PROPERTIES_0x4170, currentPosition);
            rc = iAP2FillMsgBufiAP2FavoritesListProperties(TargetBuffer, &(parameterStructure->iAP2FavoritesListProperties[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RecentListCombine_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RecentListCombine[count]),
                               currentPosition,
                               IAP2_PAR_ID_RECENT_LIST_COMBINE_0x4170,
                               iAP2_bool,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RecentListProperties_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2RecentsListProperties(&(parameterStructure->iAP2RecentListProperties[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RecentListProperties: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 1, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_RECENT_LIST_PROPERTIES_0x4170, currentPosition);
            rc = iAP2FillMsgBufiAP2RecentsListProperties(TargetBuffer, &(parameterStructure->iAP2RecentListProperties[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RecentsListMax_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RecentsListMax[count]),
                               currentPosition,
                               IAP2_PAR_ID_RECENTS_LIST_MAX_0x4170,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RequestDeviceAuthenticationChallengeResponseParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RequestDeviceAuthenticationChallengeResponseParameter* parameterStructure = (iAP2RequestDeviceAuthenticationChallengeResponseParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DeviceAuthenticationChallenge_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DeviceAuthenticationChallenge[count]),
                               currentPosition,
                               IAP2_PAR_ID_DEVICE_AUTHENTICATION_CHALLENGE_0xAA12,
                               iAP2_blob,
                               iAP2_uint8,
                               parameterStructure->iAP2DeviceAuthenticationChallenge[count].iAP2BlobLength);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StatusExternalAccessoryProtocolSessionParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StatusExternalAccessoryProtocolSessionParameter* parameterStructure = (iAP2StatusExternalAccessoryProtocolSessionParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ExternalAccessoryProtocolSessionIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_IDENTIFIER_0xEA03,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ExternalAccessoryProtocolSessionStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_SESSION_STATUS_0xEA03,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2AccessoryHIDReportParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2AccessoryHIDReportParameter* parameterStructure = (iAP2AccessoryHIDReportParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6802,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDReport_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDReport[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_REPORT_0x6802,
                               iAP2_blob,
                               iAP2_uint8,
                               parameterStructure->iAP2HIDReport[count].iAP2BlobLength);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartHIDParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartHIDParameter* parameterStructure = (iAP2StartHIDParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6800,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDReportDescriptor_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDReportDescriptor[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_REPORT_DESCRIPTOR_0x6800,
                               iAP2_blob,
                               iAP2_uint8,
                               parameterStructure->iAP2HIDReportDescriptor[count].iAP2BlobLength);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocalizedKeyboardCountryCode_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocalizedKeyboardCountryCode[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCALIZED_KEYBOARD_COUNTRY_CODE_0x6800,
                               iAP2_uint8,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ProductIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ProductIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_PRODUCT_IDENTIFIER_0x6800,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VendorIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VendorIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_VENDOR_IDENTIFIER_0x6800,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StopHIDParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StopHIDParameter* parameterStructure = (iAP2StopHIDParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_0x6803,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2LocationInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2LocationInformationParameter* parameterStructure = (iAP2LocationInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2NMEASentence_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2NMEASentence[count],
                               currentPosition,
                               IAP2_PAR_ID_NMEA_SENTENCE_0xFFFB,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2PlayMediaLibraryCollectionParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2PlayMediaLibraryCollectionParameter* parameterStructure = (iAP2PlayMediaLibraryCollectionParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CollectionPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CollectionPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_COLLECTION_PERSISTENT_IDENTIFIER_0x4C08,
                               iAP2_uint64,
                               iAP2_none,
                               sizeof(U64) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CollectionStartingIndex_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CollectionStartingIndex[count]),
                               currentPosition,
                               IAP2_PAR_ID_COLLECTION_STARTING_INDEX_0x4C08,
                               iAP2_uint32,
                               iAP2_none,
                               sizeof(U32) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CollectionType_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CollectionType[count]),
                               currentPosition,
                               IAP2_PAR_ID_COLLECTION_TYPE_0x4C08,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2MediaLibraryUniqueIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C08,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2StartingMediaItemPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_STARTING_MEDIA_ITEM_PERSISTENT_IDENTIFIER_0x4C08,
                               iAP2_uint64,
                               iAP2_none,
                               sizeof(U64) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2PlayMediaLibraryCurrentSelectionParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2PlayMediaLibraryCurrentSelectionParameter* parameterStructure = (iAP2PlayMediaLibraryCurrentSelectionParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->MediaLibraryUniqueIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->MediaLibraryUniqueIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C06,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2PlayMediaLibraryItemsParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2PlayMediaLibraryItemsParameter* parameterStructure = (iAP2PlayMediaLibraryItemsParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ItemsPersistentIdentifiers_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ItemsPersistentIdentifiers[count]),
                               currentPosition,
                               IAP2_PAR_ID_ITEMS_PERSISTENT_IDENTIFIERS_0x4C07,
                               iAP2_blob,
                               iAP2_uint64,
                               parameterStructure->iAP2ItemsPersistentIdentifiers[count].iAP2BlobLength);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->ItemsStartingIndex_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->ItemsStartingIndex[count]),
                               currentPosition,
                               IAP2_PAR_ID_ITEMS_STARTING_INDEX_0x4C07,
                               iAP2_uint32,
                               iAP2_none,
                               sizeof(U32) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->MediaLibraryUniqueIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->MediaLibraryUniqueIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C07,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2PlayMediaLibrarySpecialParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2PlayMediaLibrarySpecialParameter* parameterStructure = (iAP2PlayMediaLibrarySpecialParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AllSongs_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AllSongs[count]),
                               currentPosition,
                               IAP2_PAR_ID_ALL_SONGS_0x4C09,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2MediaLibraryUniqueIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C09,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2StartingMediaItemPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2StartingMediaItemPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_STARTING_MEDIA_ITEM_PERSISTENT_IDENTIFIER_0x4C09,
                               iAP2_uint64,
                               iAP2_none,
                               sizeof(U64) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartMediaLibraryUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartMediaLibraryUpdatesParameter* parameterStructure = (iAP2StartMediaLibraryUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LastKnownMediaLibraryRevision_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2LastKnownMediaLibraryRevision[count],
                               currentPosition,
                               IAP2_PAR_ID_LAST_KNOWN_MEDIA_LIBRARY_REVISION_0x4C03,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemProperties_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2MediaItemProperties(&(parameterStructure->iAP2MediaItemProperties[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemProperties: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 2, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_MEDIA_ITEM_PROPERTIES_0x4C03, currentPosition);
            rc = iAP2FillMsgBufiAP2MediaItemProperties(TargetBuffer, &(parameterStructure->iAP2MediaItemProperties[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaLibraryIsHidingRemoteItems_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaLibraryIsHidingRemoteItems[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_IS_HIDING_REMOTE_ITEMS_0x4C03,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2MediaLibraryUniqueIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C03,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaLibraryUpdateProgress_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaLibraryUpdateProgress[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_UPDATE_PROGRESS_0x4C03,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlaylistProperties_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2MediaPlaylistProperties(&(parameterStructure->iAP2MediaPlaylistProperties[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistProperties: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 3, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_MEDIA_PLAYLIST_PROPERTIES_0x4C03, currentPosition);
            rc = iAP2FillMsgBufiAP2MediaPlaylistProperties(TargetBuffer, &(parameterStructure->iAP2MediaPlaylistProperties[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlayAllSongsCapable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlayAllSongsCapable[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAY_ALL_SONGS_CAPABLE_0x4C03,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlaylistContentTransferInfoRequest_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2MediaPlaylistContentTransferInfoRequest(&(parameterStructure->iAP2MediaPlaylistContentTransferInfoRequest[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaPlaylistContentTransferInfoRequest: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 7, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_MEDIA_PLAYLIST_CONTENT_TRANSFER_INFO_REQUEST_0x4C03, currentPosition);
            rc = iAP2FillMsgBufiAP2MediaPlaylistContentTransferInfoRequest(TargetBuffer, &(parameterStructure->iAP2MediaPlaylistContentTransferInfoRequest[count]), currentPosition);
        }
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StopMediaLibraryUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StopMediaLibraryUpdatesParameter* parameterStructure = (iAP2StopMediaLibraryUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaLibraryUniqueIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2MediaLibraryUniqueIdentifier[count],
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_0x4C05,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2SetNowPlayingInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2SetNowPlayingInformationParameter* parameterStructure = (iAP2SetNowPlayingInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ElapsedTime_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ElapsedTime[count]),
                               currentPosition,
                               IAP2_PAR_ID_ELAPSED_TIME_0x5003,
                               iAP2_uint32,
                               iAP2_none,
                               sizeof(U32) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueIndex_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueIndex[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_INDEX_0x5003,
                               iAP2_uint32,
                               iAP2_none,
                               sizeof(U32) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueListContentTransferStartIndex_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueListContentTransferStartIndex[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_START_INDEX_0x5003,
                               iAP2_uint32,
                               iAP2_none,
                               sizeof(U32) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartNowPlayingUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartNowPlayingUpdatesParameter* parameterStructure = (iAP2StartNowPlayingUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAttributes_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2MediaItemAttributes(&(parameterStructure->iAP2MediaItemAttributes[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaItemAttributes: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 0, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_MEDIA_ITEM_ATTRIBUTES_0x5000, currentPosition);
            rc = iAP2FillMsgBufiAP2MediaItemAttributes(TargetBuffer, &(parameterStructure->iAP2MediaItemAttributes[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackAttributes_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2StartNowPlayingPlaybackAttributes(&(parameterStructure->iAP2PlaybackAttributes[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackAttributes: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 1, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_PLAYBACK_ATTRIBUTES_0x5000, currentPosition);
            rc = iAP2FillMsgBufiAP2StartNowPlayingPlaybackAttributes(TargetBuffer, &(parameterStructure->iAP2PlaybackAttributes[count]), currentPosition);
        }
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueListContentTransferInfoRequest_count) ); count++)
    {
        U16 ParameterLength    = 0;
        U16 SubParameterLength = 0;

        //Calculate the Subparameter Length
        rc = iAP2CalcLengthiAP2PlaybackQueueListContentTransferInfoRequest(&(parameterStructure->iAP2PlaybackQueueListContentTransferInfoRequest[count]), &SubParameterLength);
        if(rc == IAP2_OK)
        {
            //Calculate the Parameter Header Length
            ParameterLength += SubParameterLength;
            rc = iAP2CalculateParSpace(iAP2_none, NULL, &ParameterLength, 0);
        }
        if(rc == IAP2_OK)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PlaybackQueueListContentTransferInfoRequest: Parameter ID: %d, Parameter Header Length: %02X, Parameter Length:%02X", 2, ParameterLength, SubParameterLength);
            //Update the Parameter Header
            iAP2FillParameterHeader(TargetBuffer, ParameterLength, IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_INFO_REQUEST_0x5000, currentPosition);
            rc = iAP2FillMsgBufiAP2PlaybackQueueListContentTransferInfoRequest(TargetBuffer, &(parameterStructure->iAP2PlaybackQueueListContentTransferInfoRequest[count]), currentPosition);
        }
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2PowerSourceUpdateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2PowerSourceUpdateParameter* parameterStructure = (iAP2PowerSourceUpdateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AvailableCurrentForDevice_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AvailableCurrentForDevice[count]),
                               currentPosition,
                               IAP2_PAR_ID_AVAILABLE_CURRENT_FOR_DEVICE_0xAE03,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DeviceBatteryShouldChargeIfPowerIsPresent_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DeviceBatteryShouldChargeIfPowerIsPresent[count]),
                               currentPosition,
                               IAP2_PAR_ID_DEVICE_BATTERY_SHOULD_CHARGE_IF_POWER_IS_PRESENT_0xAE03,
                               iAP2_bool,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartPowerUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartPowerUpdatesParameter* parameterStructure = (iAP2StartPowerUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AccessoryPowerMode_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AccessoryPowerMode[count]),
                               currentPosition,
                               IAP2_PAR_ID_ACCESSORY_POWER_MODE_0xAE00,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BatteryChargeLevel_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BatteryChargeLevel[count]),
                               currentPosition,
                               IAP2_PAR_ID_BATTERY_CHARGE_LEVEL_0xAE00,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BatteryChargingState_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BatteryChargingState[count]),
                               currentPosition,
                               IAP2_PAR_ID_BATTERY_CHARGING_STATE_0xAE00,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DeviceBatteryWillChargeIfPowerIsPresent[count]),
                               currentPosition,
                               IAP2_PAR_ID_DEVICE_BATTERY_WILL_CHARGE_IF_POWER_IS_PRESENT_0xAE00,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2IsExternalChargerConnected_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2IsExternalChargerConnected[count]),
                               currentPosition,
                               IAP2_PAR_ID_IS_EXTERNAL_CHARGER_CONNECTED_0xAE00,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MaximumcurrentDrawnFromAccessory_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MaximumcurrentDrawnFromAccessory[count]),
                               currentPosition,
                               IAP2_PAR_ID_MAXIMUMCURRENT_DRAWN_FROM_ACCESSORY_0xAE00,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartTelephonyCallStateInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartTelephonyCallStateInformationParameter* parameterStructure = (iAP2StartTelephonyCallStateInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CallStatevCardFileTransferIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CallStatevCardFileTransferIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_CALL_STATEV_CARD_FILE_TRANSFER_IDENTIFIER_0x4154,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartTelephonyUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartTelephonyUpdatesParameter* parameterStructure = (iAP2StartTelephonyUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TelephonySignalStrength_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TelephonySignalStrength[count]),
                               currentPosition,
                               IAP2_PAR_ID_TELEPHONY_SIGNAL_STRENGTH_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TelephonyRegistrationStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TelephonyRegistrationStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_TELEPHONY_REGISTRATION_STATUS_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TelephonyAirplaneModeStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TelephonyAirplaneModeStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_TELEPHONY_AIRPLANE_MODE_STATUS_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TelephonyTTYStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TelephonyTTYStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_TELEPHONY_TTY_STATUS_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TelephonyMobileOperator_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TelephonyMobileOperator[count]),
                               currentPosition,
                               IAP2_PAR_ID_TELEPHONY_MOBILE_OPERATOR_0x4157,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2VehicleStatusUpdateParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2VehicleStatusUpdateParameter* parameterStructure = (iAP2VehicleStatusUpdateParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2NightMode_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2NightMode[count]),
                               currentPosition,
                               IAP2_PAR_ID_NIGHT_MODE_0xA101,
                               iAP2_bool,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Range_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Range[count]),
                               currentPosition,
                               IAP2_PAR_ID_RANGE_0xA101,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2OutsideTemperature_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2OutsideTemperature[count]),
                               currentPosition,
                               IAP2_PAR_ID_OUTSIDE_TEMPERATURE_0xA101,
                               iAP2_int16,
                               iAP2_none,
                               sizeof(S16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2InsideTemperature_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2InsideTemperature[count]),
                               currentPosition,
                               IAP2_PAR_ID_INSIDE_TEMPERATURE_0xA101,
                               iAP2_int16,
                               iAP2_none,
                               sizeof(S16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RangeWarning_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RangeWarning[count]),
                               currentPosition,
                               IAP2_PAR_ID_RANGE_WARNING_0xA101,
                               iAP2_bool,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RequestVoiceOverConfigurationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RequestVoiceOverConfigurationParameter* parameterStructure = (iAP2RequestVoiceOverConfigurationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverSpeakingRate_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverSpeakingRate[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_SPEAKING_RATE_0x560E,
                               iAP2_uint8,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverSpeakingVolume_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverSpeakingVolume[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_SPEAKING_VOLUME_0x560E,
                               iAP2_uint8,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RequestVoiceOverMoveCursorParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RequestVoiceOverMoveCursorParameter* parameterStructure = (iAP2RequestVoiceOverMoveCursorParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2CursorDirection_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2CursorDirection[count]),
                               currentPosition,
                               IAP2_PAR_ID_CURSOR_DIRECTION_0x5601,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RequestVoiceOverScrollPageParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RequestVoiceOverScrollPageParameter* parameterStructure = (iAP2RequestVoiceOverScrollPageParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ScrollDirection_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ScrollDirection[count]),
                               currentPosition,
                               IAP2_PAR_ID_SCROLL_DIRECTION_0x5603,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RequestVoiceOverSpeakTextParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RequestVoiceOverSpeakTextParameter* parameterStructure = (iAP2RequestVoiceOverSpeakTextParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverTextToSpeak_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2VoiceOverTextToSpeak[count],
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_TEXT_TO_SPEAK_0x5606,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartVoiceOverCursorUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartVoiceOverCursorUpdatesParameter* parameterStructure = (iAP2StartVoiceOverCursorUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverHint_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverHint[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_HINT_0x560F,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverLabel_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverLabel[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_LABEL_0x560F,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverTraits_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverTraits[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_TRAITS_0x560F,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverValue_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverValue[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_VALUE_0x560F,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartVoiceOverUpdatesParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartVoiceOverUpdatesParameter* parameterStructure = (iAP2StartVoiceOverUpdatesParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverEnabled_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverEnabled[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_ENABLED_0x560B,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverSpeakingRate_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverSpeakingRate[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_SPEAKING_RATE_0x560B,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2VoiceOverSpeakingVolume_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2VoiceOverSpeakingVolume[count]),
                               currentPosition,
                               IAP2_PAR_ID_VOICE_OVER_SPEAKING_VOLUME_0x560B,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2AccessoryWiFiConfigurationInformationParameter(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2AccessoryWiFiConfigurationInformationParameter* parameterStructure = (iAP2AccessoryWiFiConfigurationInformationParameter*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Channel_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Channel[count]),
                               currentPosition,
                               IAP2_PAR_ID_CHANNEL_0x5703,
                               iAP2_uint8,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Passphrase_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2Passphrase[count],
                               currentPosition,
                               IAP2_PAR_ID_PASSPHRASE_0x5703,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2SecurityType_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2SecurityType[count]),
                               currentPosition,
                               IAP2_PAR_ID_SECURITY_TYPE_0x5703,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2WiFiSSID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2WiFiSSID[count],
                               currentPosition,
                               IAP2_PAR_ID_WI_FI_SSID_0x5703,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2BluetoothComponentStatus(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2BluetoothComponentStatus* parameterStructure = (iAP2BluetoothComponentStatus*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BTComponentEnabled_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BTComponentEnabled[count]),
                               currentPosition,
                               IAP2_PAR_ID_BT_COMPONENT_ENABLED_SPID_1,
                               iAP2_bool,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BTComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BTComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_BT_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2BluetoothHIDComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2BluetoothHIDComponent* parameterStructure = (iAP2BluetoothHIDComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BluetoothTransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BluetoothTransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_BLUETOOTH_TRANSPORT_COMPONENT_IDENTIFIER_SPID_3,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentFunction_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentFunction[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_FUNCTION_SPID_2,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2HIDComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2BluetoothTransportComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2BluetoothTransportComponent* parameterStructure = (iAP2BluetoothTransportComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress[count]),
                               currentPosition,
                               IAP2_PAR_ID_BLUETOOTH_TRANSPORT_MEDIA_ACCESS_CONTROL_ADDRESS_SPID_3,
                               iAP2_blob,
                               iAP2_uint8,
                               parameterStructure->iAP2BluetoothTransportMediaAccessControlAddress[count].iAP2BlobLength);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2TransportComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportSupportsiAP2Connection_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportSupportsiAP2Connection[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2ExternalAccessoryProtocol(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2ExternalAccessoryProtocol* parameterStructure = (iAP2ExternalAccessoryProtocol*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ExternalAccessoryProtocolCarPlay_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ExternalAccessoryProtocolCarPlay[count]),
                               currentPosition,
                               IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_CAR_PLAY_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ExternalAccessoryProtocolIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ExternalAccessoryProtocolIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_IDENTIFIER_SPID_0,
                               iAP2_uint8,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ExternalAccessoryProtocolMatchAction_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2ExternalAccessoryProtocolMatchAction[count]),
                               currentPosition,
                               IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_MATCH_ACTION_SPID_2,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2ExternalAccessoryProtocolName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2ExternalAccessoryProtocolName[count],
                               currentPosition,
                               IAP2_PAR_ID_EXTERNAL_ACCESSORY_PROTOCOL_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2NativeTransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2NativeTransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_NATIVE_TRANSPORT_COMPONENT_IDENTIFIER_SPID_3,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2FavoritesListProperties(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2FavoritesListProperties* parameterStructure = (iAP2FavoritesListProperties*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AddressBookID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AddressBookID[count]),
                               currentPosition,
                               IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DisplayName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DisplayName[count]),
                               currentPosition,
                               IAP2_PAR_ID_DISPLAY_NAME_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Index_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Index[count]),
                               currentPosition,
                               IAP2_PAR_ID_INDEX_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Label_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Label[count]),
                               currentPosition,
                               IAP2_PAR_ID_LABEL_SPID_3,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RemoteID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RemoteID[count]),
                               currentPosition,
                               IAP2_PAR_ID_REMOTE_ID_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Service_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Service[count]),
                               currentPosition,
                               IAP2_PAR_ID_SERVICE_SPID_5,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2iAP2HIDComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2iAP2HIDComponent* parameterStructure = (iAP2iAP2HIDComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentFunction_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentFunction[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_FUNCTION_SPID_2,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2HIDComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2LocationInformationComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2LocationInformationComponent* parameterStructure = (iAP2LocationInformationComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentGlobalPositioningSystemFixData_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentGlobalPositioningSystemFixData[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_GLOBAL_POSITIONING_SYSTEM_FIX_DATA_SPID_17,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentGPSSatelliteInView_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentGPSSatelliteInView[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_GPS_SATELLITE_IN_VIEW_SPID_19,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2LocationInformationComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_RECOMMENDED_MINIMUM_SPECIFIC_GPS_TRANSIT_DATA_SPID_18,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentVehicleAccelerometerData_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentVehicleAccelerometerData[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_ACCELEROMETER_DATA_SPID_22,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentVehicleGyroData_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentVehicleGyroData[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_GYRO_DATA_SPID_21,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentVehicleHeadingData_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentVehicleHeadingData[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_HEADING_DATA_SPID_23,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2LocationInformationComponentVehicleSpeedData_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2LocationInformationComponentVehicleSpeedData[count]),
                               currentPosition,
                               IAP2_PAR_ID_LOCATION_INFORMATION_COMPONENT_VEHICLE_SPEED_DATA_SPID_20,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2MediaItemAttributes(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2MediaItemAttributes* parameterStructure = (iAP2MediaItemAttributes*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumDiscCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumDiscCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_COUNT_SPID_10,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumDiscNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumDiscNumber[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_DISC_NUMBER_SPID_9,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumTrackCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumTrackCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_COUNT_SPID_8,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumTrackNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumTrackNumber[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TRACK_NUMBER_SPID_7,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemArtist_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemArtist[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemArtworkFileTransferIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemArtworkFileTransferIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ARTWORK_FILE_TRANSFER_IDENTIFIER_SPID_26,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemChapterCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemChapterCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_CHAPTER_COUNT_SPID_27,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemComposer_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemComposer[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemGenre_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemGenre[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemIsBanned_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemIsBanned[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_IS_BANNED_SPID_24,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemIsBanSupported_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemIsBanSupported[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_IS_BAN_SUPPORTED_SPID_22,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemIsLiked_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemIsLiked[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_IS_LIKED_SPID_23,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemIsLikeSupported_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemIsLikeSupported[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_IS_LIKE_SUPPORTED_SPID_21,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PERSISTENT_IDENTIFIER_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPlaybackDurationInMilliseconds_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPlaybackDurationInMilliseconds[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PLAYBACK_DURATION_IN_MILLISECONDS_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_TITLE_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2MediaItemProperties(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2MediaItemProperties* parameterStructure = (iAP2MediaItemProperties*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumArtist_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumArtist[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_ARTIST_SPID_14,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_ARTIST_PERSISTENT_IDENTIFIER_SPID_13,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumDiscCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumDiscCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_DISC_COUNT_SPID_10,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumDiscNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumDiscNumber[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_DISC_NUMBER_SPID_9,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_PERSISTENT_IDENTIFIER_SPID_5,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_TITLE_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumTrackCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumTrackCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_TRACK_COUNT_SPID_8,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyAlbumTrackNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyAlbumTrackNumber[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ALBUM_TRACK_NUMBER_SPID_7,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyArtist_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyArtist[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ARTIST_SPID_12,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyArtistPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyArtistPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_ARTIST_PERSISTENT_IDENTIFIER_SPID_11,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyChapterCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyChapterCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_CHAPTER_COUNT_SPID_27,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyComposer_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyComposer[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_COMPOSER_SPID_18,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyComposerPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyComposerPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_COMPOSER_PERSISTENT_IDENTIFIER_SPID_17,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyGenre_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyGenre[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_GENRE_SPID_16,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyGenrePersistenIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyGenrePersistenIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_GENRE_PERSISTEN_IDENTIFIER_SPID_15,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyIsBanned_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyIsBanned[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_BANNED_SPID_24,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyIsBanSupported_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyIsBanSupported[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_BAN_SUPPORTED_SPID_22,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyIsLiked_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyIsLiked[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_LIKED_SPID_23,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyIsLikeSupported_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyIsLikeSupported[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_LIKE_SUPPORTED_SPID_21,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyIsPartOfCompilation_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyIsPartOfCompilation[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_PART_OF_COMPILATION_SPID_19,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyIsResidentOndevice_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyIsResidentOndevice[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_IS_RESIDENT_ONDEVICE_SPID_25,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyMediaType_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyMediaType[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_MEDIA_TYPE_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_PERSISTENT_IDENTIFIER_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyPlaybackDurationInMilliseconds[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_PLAYBACK_DURATION_IN_MILLISECONDS_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyRating_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyRating[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_RATING_SPID_3,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPropertyTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPropertyTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PROPERTY_TITLE_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2MediaPlaylistContentTransferInfoRequest(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2MediaPlaylistContentTransferInfoRequest* parameterStructure = (iAP2MediaPlaylistContentTransferInfoRequest*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MedialtemPlD_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MedialtemPlD[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIALTEM_PL_D_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MedialtemTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MedialtemTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIALTEM_TITLE_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemArtist_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemArtist[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MedialtemAlbumArtist_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MedialtemAlbumArtist[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIALTEM_ALBUM_ARTIST_SPID_14,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemGenre_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemGenre[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemComposer_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemComposer[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2MediaPlaylistProperties(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2MediaPlaylistProperties* parameterStructure = (iAP2MediaPlaylistProperties*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListContainedMediaItems_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListContainedMediaItems[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_CONTAINED_MEDIA_ITEMS_SPID_5,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_CONTAINED_MEDIA_ITEMS_FILE_TRANSFER_IDENTIFIER_SPID_5,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListPropertyIsAppleMusicRadioStation_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListPropertyIsAppleMusicRadioStation[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_IS_APPLE_MUSIC_RADIO_STATION_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListPropertyIsFolder_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListPropertyIsFolder[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_IS_FOLDER_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListPropertyIsiTunesRadioStation_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListPropertyIsiTunesRadioStation[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_ISI_TUNES_RADIO_STATION_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListPropertyName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListPropertyName[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_NAME_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListPropertyParentPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListPropertyParentPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_PARENT_PERSISTENT_IDENTIFIER_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListPropertyPersistentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_PERSISTENT_IDENTIFIER_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlayListPropertyPropertyIsGeniusMix_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlayListPropertyPropertyIsGeniusMix[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAY_LIST_PROPERTY_PROPERTY_IS_GENIUS_MIX_SPID_3,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaPlaylistContentTransfer_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaPlaylistContentTransfer[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_PLAYLIST_CONTENT_TRANSFER_SPID_7,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2PlaybackQueueListContentTransferInfoRequest(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2PlaybackQueueListContentTransferInfoRequest* parameterStructure = (iAP2PlaybackQueueListContentTransferInfoRequest*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemPID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemPID[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_PID_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_TITLE_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumTitle_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumTitle[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_TITLE_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemArtist_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemArtist[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ARTIST_SPID_12,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemAlbumArtist_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemAlbumArtist[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_ALBUM_ARTIST_SPID_14,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemGenre_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemGenre[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_GENRE_SPID_16,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MediaItemComposer_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MediaItemComposer[count]),
                               currentPosition,
                               IAP2_PAR_ID_MEDIA_ITEM_COMPOSER_SPID_18,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RecentsListProperties(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RecentsListProperties* parameterStructure = (iAP2RecentsListProperties*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2AddressBookID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2AddressBookID[count]),
                               currentPosition,
                               IAP2_PAR_ID_ADDRESS_BOOK_ID_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DisplayName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2DisplayName[count]),
                               currentPosition,
                               IAP2_PAR_ID_DISPLAY_NAME_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Duration_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Duration[count]),
                               currentPosition,
                               IAP2_PAR_ID_DURATION_SPID_8,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Index_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Index[count]),
                               currentPosition,
                               IAP2_PAR_ID_INDEX_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Label_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Label[count]),
                               currentPosition,
                               IAP2_PAR_ID_LABEL_SPID_3,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Occurrences_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Occurrences[count]),
                               currentPosition,
                               IAP2_PAR_ID_OCCURRENCES_SPID_9,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RemoteID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RemoteID[count]),
                               currentPosition,
                               IAP2_PAR_ID_REMOTE_ID_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Service_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Service[count]),
                               currentPosition,
                               IAP2_PAR_ID_SERVICE_SPID_5,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Type_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Type[count]),
                               currentPosition,
                               IAP2_PAR_ID_TYPE_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2UnixTimestamp_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2UnixTimestamp[count]),
                               currentPosition,
                               IAP2_PAR_ID_UNIX_TIMESTAMP_SPID_7,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2RouteGuidanceDisplayComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2RouteGuidanceDisplayComponent* parameterStructure = (iAP2RouteGuidanceDisplayComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Identifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Identifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Name_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2Name[count],
                               currentPosition,
                               IAP2_PAR_ID_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MaxCurrentRoadNameLength_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MaxCurrentRoadNameLength[count]),
                               currentPosition,
                               IAP2_PAR_ID_MAX_CURRENT_ROAD_NAME_LENGTH_SPID_2,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MaxDestinationRoadNameLength_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MaxDestinationRoadNameLength[count]),
                               currentPosition,
                               IAP2_PAR_ID_MAX_DESTINATION_ROAD_NAME_LENGTH_SPID_3,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MaxAfterManeuverRoadNameLength_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MaxAfterManeuverRoadNameLength[count]),
                               currentPosition,
                               IAP2_PAR_ID_MAX_AFTER_MANEUVER_ROAD_NAME_LENGTH_SPID_4,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MaxManeuverDescriptionLength_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MaxManeuverDescriptionLength[count]),
                               currentPosition,
                               IAP2_PAR_ID_MAX_MANEUVER_DESCRIPTION_LENGTH_SPID_5,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2MaxGuidanceManeuverStorageCapacity_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2MaxGuidanceManeuverStorageCapacity[count]),
                               currentPosition,
                               IAP2_PAR_ID_MAX_GUIDANCE_MANEUVER_STORAGE_CAPACITY_SPID_6,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2SerialTransportComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2SerialTransportComponent* parameterStructure = (iAP2SerialTransportComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2TransportComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportSupportsiAP2Connection_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportSupportsiAP2Connection[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2StartNowPlayingPlaybackAttributes(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2StartNowPlayingPlaybackAttributes* parameterStructure = (iAP2StartNowPlayingPlaybackAttributes*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID[count]),
                               currentPosition,
                               IAP2_PAR_ID_PB_APPE_MUSIC_RADIO_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PBAppleMusicRadioAd_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PBAppleMusicRadioAd[count]),
                               currentPosition,
                               IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_AD_SPID_9,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PBAppleMusicRadioStationName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PBAppleMusicRadioStationName[count]),
                               currentPosition,
                               IAP2_PAR_ID_PB_APPLE_MUSIC_RADIO_STATION_NAME_SPID_10,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PBiTunesRadioAd_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PBiTunesRadioAd[count]),
                               currentPosition,
                               IAP2_PAR_ID_P_BI_TUNES_RADIO_AD_SPID_9,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PBiTunesStationMediaPlaylistPersistentID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PBiTunesStationMediaPlaylistPersistentID[count]),
                               currentPosition,
                               IAP2_PAR_ID_P_BI_TUNES_STATION_MEDIA_PLAYLIST_PERSISTENT_ID_SPID_11,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PBiTunesStationName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PBiTunesStationName[count]),
                               currentPosition,
                               IAP2_PAR_ID_P_BI_TUNES_STATION_NAME_SPID_10,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackAppBundleID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackAppBundleID[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_APP_BUNDLE_ID_SPID_16,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackAppName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackAppName[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_APP_NAME_SPID_7,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackElapsedTimeInMilliseconds_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackElapsedTimeInMilliseconds[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_ELAPSED_TIME_IN_MILLISECONDS_SPID_1,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackMediaLibraryUniqueIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackMediaLibraryUniqueIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_MEDIA_LIBRARY_UNIQUE_IDENTIFIER_SPID_8,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueChapterIndex_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueChapterIndex[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_CHAPTER_INDEX_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueCount_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueCount[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_COUNT_SPID_3,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueIndex_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueIndex[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_INDEX_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueListAvail_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueListAvail[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_AVAIL_SPID_14,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueListTransferID_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueListTransferID[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_TRANSFER_ID_SPID_15,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackRepeatMode_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackRepeatMode[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_REPEAT_MODE_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackShuffleMode_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackShuffleMode[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_SHUFFLE_MODE_SPID_5,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackSpeed_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackSpeed[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_SPEED_SPID_12,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackStatus_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackStatus[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_STATUS_SPID_0,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2SetElapsedTimeAvailable_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2SetElapsedTimeAvailable[count]),
                               currentPosition,
                               IAP2_PAR_ID_SET_ELAPSED_TIME_AVAILABLE_SPID_13,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2PlaybackQueueListContentTransferSize_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2PlaybackQueueListContentTransferSize[count]),
                               currentPosition,
                               IAP2_PAR_ID_PLAYBACK_QUEUE_LIST_CONTENT_TRANSFER_SIZE_SPID_17,
                               iAP2_uint32,
                               iAP2_none,
                               sizeof(U32) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2USBDeviceTransportComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2USBDeviceTransportComponent* parameterStructure = (iAP2USBDeviceTransportComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2TransportComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportSupportsiAP2Connection_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportSupportsiAP2Connection[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2USBDeviceSupportedAudioSampleRate_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2USBDeviceSupportedAudioSampleRate[count]),
                               currentPosition,
                               IAP2_PAR_ID_USB_DEVICE_SUPPORTED_AUDIO_SAMPLE_RATE_SPID_3,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2USBHostHIDComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2USBHostHIDComponent* parameterStructure = (iAP2USBHostHIDComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentFunction_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentFunction[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_FUNCTION_SPID_2,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2HIDComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2HIDComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2HIDComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_HID_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2USBHostTransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2USBHostTransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_USB_HOST_TRANSPORT_COMPONENT_IDENTIFIER_SPID_3,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2USBHostTransportInterfaceNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2USBHostTransportInterfaceNumber[count]),
                               currentPosition,
                               IAP2_PAR_ID_USB_HOST_TRANSPORT_INTERFACE_NUMBER_SPID_4,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2USBHostTransportComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2USBHostTransportComponent* parameterStructure = (iAP2USBHostTransportComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2TransportComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportSupportsCarPlay_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportSupportsCarPlay[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_SUPPORTS_CAR_PLAY_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportSupportsiAP2Connection_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportSupportsiAP2Connection[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2USBHostTransportCarPlaytInterfaceNumber_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2USBHostTransportCarPlaytInterfaceNumber[count]),
                               currentPosition,
                               IAP2_PAR_ID_USB_HOST_TRANSPORT_CAR_PLAYT_INTERFACE_NUMBER_SPID_3,
                               iAP2_uint8,
                               iAP2_none,
                               sizeof(U8) );
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2VehicleInformationComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2VehicleInformationComponent* parameterStructure = (iAP2VehicleInformationComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2DisplayName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2DisplayName[count],
                               currentPosition,
                               IAP2_PAR_ID_DISPLAY_NAME_SPID_6,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2EngineType_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2EngineType[count]),
                               currentPosition,
                               IAP2_PAR_ID_ENGINE_TYPE_SPID_2,
                               iAP2_enum,
                               iAP2_none,
                               sizeof(U8) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Identifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Identifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Name_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2Name[count],
                               currentPosition,
                               IAP2_PAR_ID_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2VehicleStatusComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2VehicleStatusComponent* parameterStructure = (iAP2VehicleStatusComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Identifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Identifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2InsideTemperature_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2InsideTemperature[count]),
                               currentPosition,
                               IAP2_PAR_ID_INSIDE_TEMPERATURE_SPID_5,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Name_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2Name[count],
                               currentPosition,
                               IAP2_PAR_ID_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2NightMode_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2NightMode[count]),
                               currentPosition,
                               IAP2_PAR_ID_NIGHT_MODE_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2OutsideTemperature_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2OutsideTemperature[count]),
                               currentPosition,
                               IAP2_PAR_ID_OUTSIDE_TEMPERATURE_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2Range_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2Range[count]),
                               currentPosition,
                               IAP2_PAR_ID_RANGE_SPID_3,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2RangeWarning_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2RangeWarning[count]),
                               currentPosition,
                               IAP2_PAR_ID_RANGE_WARNING_SPID_6,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}

S32 iAP2FillMsgBufiAP2WirelessCarPlayTransportComponent(U8* TargetBuffer, const void* paramStructure, U16* currentPosition)
{
    S32 rc = IAP2_OK;
    U16 count;
    const iAP2WirelessCarPlayTransportComponent* parameterStructure = (iAP2WirelessCarPlayTransportComponent*)paramStructure;

    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentIdentifier_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportComponentIdentifier[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_IDENTIFIER_SPID_0,
                               iAP2_uint16,
                               iAP2_none,
                               sizeof(U16) );
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportComponentName_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               parameterStructure->iAP2TransportComponentName[count],
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_COMPONENT_NAME_SPID_1,
                               iAP2_utf8,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportSupportsCarPlay_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportSupportsCarPlay[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_SUPPORTS_CAR_PLAY_SPID_4,
                               iAP2_none,
                               iAP2_none, 0);
    }
    for(count = 0; ( (rc == IAP2_OK) && (count < parameterStructure->iAP2TransportSupportsiAP2Connection_count) ); count++)
    {
        rc = iAP2FillParameter(TargetBuffer,
                               &(parameterStructure->iAP2TransportSupportsiAP2Connection[count]),
                               currentPosition,
                               IAP2_PAR_ID_TRANSPORT_SUPPORTSI_AP2CONNECTION_SPID_2,
                               iAP2_none,
                               iAP2_none, 0);
    }

    return rc;
}
